/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity.genetics;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.HorseColors;
import sekelsta.horse_colors.breed.Breed;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.genetics.FakeGeneticEntity;
import sekelsta.horse_colors.entity.genetics.Genome;
import sekelsta.horse_colors.entity.genetics.HorseAlleles;
import sekelsta.horse_colors.entity.genetics.HorseColorCalculator;
import sekelsta.horse_colors.entity.genetics.HorsePatternCalculator;
import sekelsta.horse_colors.entity.genetics.IGeneticEntity;
import sekelsta.horse_colors.entity.genetics.Species;
import sekelsta.horse_colors.util.RandomSupplier;
import sekelsta.horse_colors.util.Util;

public class EquineGenome
extends Genome {
    public static final double MINIATURE_CUTOFF = 317.5;
    private static final ImmutableList<String> chromosomes = ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"speed", (Object)"jump", (Object)"health", (Object)"mhc1", (Object)"mhc2", (Object)"immune", (Object)"random", (Object)"4", (Object[])new String[0]);

    public EquineGenome(Species species, IGeneticEntity entityIn) {
        super(species, entityIn, new RandomSupplier((List)ImmutableList.of((Object)"leg_white", (Object)"face_white", (Object)"star_choice", (Object)"roan_density", (Object)"liver_darkness", (Object)"shade", (Object)"size")));
    }

    public EquineGenome(Species species) {
        this(species, new FakeGeneticEntity());
    }

    @Override
    public List<Enum> listGenes() {
        return Arrays.asList(Gene.values());
    }

    @Override
    public List<Genome.Linkage> listLinkages() {
        List<Genome.Linkage> linkages = super.listLinkages();
        linkages.add(new Genome.Linkage(Gene.extension, 0.2f));
        linkages.add(new Genome.Linkage(Gene.KIT));
        linkages.add(new Genome.Linkage(Gene.agouti, 0.0f));
        linkages.add(new Genome.Linkage(Gene.light_belly));
        for (int i = 0; i < 7; ++i) {
            linkages.add(new Genome.Linkage(Gene.valueOf("mhc" + i), 0.2f));
        }
        linkages.add(new Genome.Linkage(Gene.mhc7));
        return linkages;
    }

    @Override
    public int getGeneSize(String gene) {
        switch (gene) {
            case "KIT": {
                return 6;
            }
            case "MITF": 
            case "PAX3": {
                return 4;
            }
            case "cream": 
            case "extension": 
            case "agouti": {
                return 3;
            }
            case "dun": {
                return 2;
            }
        }
        return 1;
    }

    public void printGeneData() {
        String g = this.entity.getGeneData();
        String gene_debug = "";
        for (int i = 0; i < g.length(); ++i) {
            gene_debug = gene_debug + (short)g.charAt(i) + " ";
        }
        System.out.println(gene_debug);
    }

    public boolean isChestnut() {
        return this.isHomozygous(Gene.extension, 0);
    }

    public boolean hasCream() {
        return this.hasAllele(Gene.cream, 3);
    }

    public boolean isPearl() {
        return this.isHomozygous(Gene.cream, 2);
    }

    public boolean isDoubleCream() {
        return this.isHomozygous(Gene.cream, 3) || this.isHomozygous(Gene.cream, 1) || this.hasAllele(Gene.cream, 3) && this.hasAllele(Gene.cream, 1);
    }

    public boolean isCreamPearl() {
        return (this.hasAllele(Gene.cream, 3) || this.hasAllele(Gene.cream, 1)) && this.hasAllele(Gene.cream, 2);
    }

    public boolean isMushroom() {
        return this.isHomozygous(Gene.mushroom, 1);
    }

    public boolean isSilver() {
        return this.hasAllele(Gene.silver, 1);
    }

    public boolean isGray() {
        return this.hasAllele(Gene.gray, 1);
    }

    public boolean isDun() {
        return this.hasAllele(Gene.donkey_dun, 0) && (this.hasAllele(Gene.dun, 2) || this.isHomozygous(Gene.dun, 3));
    }

    public boolean hasStripe() {
        if (this.isHomozygous(Gene.dun, 0)) {
            return false;
        }
        if (this.isHomozygous(Gene.donkey_dun, 2)) {
            return false;
        }
        if (this.hasAllele(Gene.dun, 2)) {
            return true;
        }
        if (this.hasAllele(Gene.donkey_dun, 0)) {
            return true;
        }
        if (this.hasAllele(Gene.dun, 0)) {
            return false;
        }
        return this.hasAllele(Gene.dun, 3);
    }

    public boolean isMealy() {
        return this.getAllele(Gene.light_belly, 0) == 1 && this.getAllele(Gene.agouti, 0) != 0 || this.getAllele(Gene.light_belly, 1) == 1 && this.getAllele(Gene.agouti, 1) != 0;
    }

    public boolean hasMC1RWhiteBoost() {
        return this.isChestnut();
    }

    public boolean isTobiano() {
        return HorseAlleles.isTobianoAllele(this.getAllele(Gene.KIT, 0)) || HorseAlleles.isTobianoAllele(this.getAllele(Gene.KIT, 1));
    }

    public boolean isWhite() {
        return this.hasAllele(Gene.KIT, 15) || this.isLethalWhite() || this.isHomozygous(Gene.KIT, 12) || this.hasAllele(Gene.KIT, 12) && (this.hasAllele(Gene.frame, 1) || this.isTobiano()) && this.isHomozygous(Gene.MITF, 0);
    }

    public boolean showsLegMarkings() {
        return !this.isWhite() && !this.isTobiano();
    }

    public boolean isDappleInclined() {
        return this.isHomozygous(Gene.dapple, 1);
    }

    public boolean isLethalWhite() {
        return this.isHomozygous(Gene.frame, 1);
    }

    public boolean isEmbryonicLethal() {
        return this.isHomozygous(Gene.KIT, 15);
    }

    public boolean hasERURiskFactor() {
        return this.getAllele(Gene.mhc1, 0) % 4 == 3 && this.getAllele(Gene.mhc1, 1) % 4 == 3;
    }

    public boolean isAlbino() {
        return this.isHomozygous(Gene.color, 1);
    }

    public int getSootyLevel() {
        int sooty = this.getMaxAllele(Gene.sooty1) + this.getMaxAllele(Gene.sooty2);
        sooty += 1 - this.getMaxAllele(Gene.sooty3);
        if (!this.isChestnut()) {
            sooty += 1 - 2 * this.getMaxAllele(Gene.reduced_points);
            sooty = Math.max(0, sooty);
        }
        return sooty;
    }

    public float getGrayRate() {
        int gray = this.countAlleles(Gene.gray, 1);
        float rate = 3.0f * (float)(3 - gray);
        if (this.isHomozygous(Gene.slow_gray1, 1)) {
            rate *= 1.5f;
        } else if (this.hasAllele(Gene.slow_gray1, 1)) {
            rate *= 1.2f;
        }
        if (this.hasAllele(Gene.slow_gray2, 1)) {
            rate *= 1.3f;
        }
        if (this.isHomozygous(Gene.slow_gray3, 1)) {
            rate *= 1.2f;
        }
        if (this.hasAllele(Gene.gray_mane1, 1)) {
            rate *= 1.2f;
        }
        return rate;
    }

    public float getGrayManeRate() {
        float rate = this.getGrayRate();
        if (this.hasAllele(Gene.gray_mane1, 0)) {
            rate *= 0.9f;
        }
        if (this.isHomozygous(Gene.gray_mane2, 0)) {
            rate *= 0.9f;
        }
        return rate * 17.0f / 19.0f;
    }

    public float getImmuneHealth() {
        float scale = 7.0f;
        int diffs = 0;
        for (int i = 0; i < 8; ++i) {
            Gene mhc_gene;
            Gene immune_gene = Gene.valueOf("immune" + i);
            if (this.getAllele(immune_gene, 0) != this.getAllele(immune_gene, 1)) {
                ++diffs;
            }
            if (this.getAllele(mhc_gene = Gene.valueOf("mhc" + i), 0) == this.getAllele(mhc_gene, 1)) continue;
            ++diffs;
        }
        float heterozygosity = (float)diffs / 12.0f;
        if (heterozygosity > 1.0f) {
            heterozygosity = 0.25f * (heterozygosity - 1.0f) + 1.0f;
        }
        return Math.min(scale, scale * heterozygosity);
    }

    public float getGrayHealthLoss() {
        float base = this.countAlleles(Gene.gray, 1);
        if (this.isHomozygous(Gene.gray_melanoma, 0)) {
            base -= 1.0f;
        }
        if (this.isWhite()) {
            base -= 1.5f;
        }
        return Math.max(0.0f, base);
    }

    public float getSilverHealthLoss() {
        if (this.isHomozygous(Gene.silver, 1)) {
            return 1.0f;
        }
        if (this.hasAllele(Gene.silver, 1)) {
            return 0.5f;
        }
        return 0.0f;
    }

    public float getDeafHealthLoss() {
        if (HorsePatternCalculator.hasPigmentInEars(this)) {
            return 0.0f;
        }
        return 1.0f;
    }

    public float getERUHealthLoss() {
        if (this.hasERURiskFactor()) {
            return 0.5f * (float)this.countAlleles(Gene.leopard, 1);
        }
        return 0.0f;
    }

    public float getBaseHealth() {
        if (((Boolean)HorseConfig.Genetics.enableHealthEffects.get()).booleanValue()) {
            return -this.getGrayHealthLoss() - this.getSilverHealthLoss() - this.getDeafHealthLoss() - this.getERUHealthLoss();
        }
        return 0.0f;
    }

    public float getHealth() {
        float healthStat = (float)(this.sumGenes(Gene.class, "health", 0, 4) + this.sumGenes(Gene.class, "health", 4, 8) + this.sumGenes(Gene.class, "health", 8, 12)) + this.getImmuneHealth();
        float maxHealth = 15.0f + healthStat * 0.5f;
        if (((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue()) {
            maxHealth *= Math.min(this.getAdultScale() / 1.1f, 1.5f);
        }
        return Math.max(maxHealth += this.getBaseHealth(), 4.0f);
    }

    public int countW20() {
        return this.countAlleles(Gene.KIT, 7) + this.countAlleles(Gene.KIT, 13);
    }

    private float getSizeContribution(Enum gene, int allele, float coef) {
        float size = 1.0f;
        for (int i = 0; i < this.countAlleles(gene, allele); ++i) {
            size *= coef;
        }
        return size;
    }

    public float getGeneticScale() {
        int n;
        float size = 1.0f;
        if (this.species == Species.DONKEY) {
            size *= 0.9f;
        } else if (this.species == Species.MULE || this.species == Species.HINNY) {
            size *= 0.98f;
        }
        if (!((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue()) {
            return size * 1.1f;
        }
        size *= this.entity.isMale() ? 1.01f : 0.99f;
        size *= this.getSizeContribution(Gene.LCORL, 1, 1.03f);
        if (this.isHomozygous(Gene.HMGA2, 1)) {
            size *= 0.81f;
        } else if (this.hasAllele(Gene.HMGA2, 1)) {
            size *= 0.94f;
        }
        size *= this.getSizeContribution(Gene.size_minor0, 1, 1.002f);
        size *= this.getSizeContribution(Gene.size_minor0, 2, 0.998004f);
        size *= this.getSizeContribution(Gene.size_minor0, 3, 1.009f);
        size *= this.getSizeContribution(Gene.size_minor0, 4, 0.99108034f);
        size *= this.getSizeContribution(Gene.size_minor1, 1, 1.003f);
        size *= this.getSizeContribution(Gene.size_minor1, 2, 0.997009f);
        size *= this.getSizeContribution(Gene.size_minor1, 3, 1.015f);
        size *= this.getSizeContribution(Gene.size_minor1, 4, 0.9852217f);
        size *= this.getSizeContribution(Gene.size_minor2, 1, 1.001f);
        size *= this.getSizeContribution(Gene.size_minor2, 2, 0.99900097f);
        size *= this.getSizeContribution(Gene.size_minor2, 3, 1.012f);
        size *= this.getSizeContribution(Gene.size_minor2, 4, 0.9881423f);
        size *= this.getSizeContribution(Gene.size_minor3, 1, 1.001f);
        size *= this.getSizeContribution(Gene.size_minor3, 2, 0.99900097f);
        size *= this.getSizeContribution(Gene.size_minor3, 3, 1.01f);
        size *= this.getSizeContribution(Gene.size_minor3, 4, 0.990099f);
        size *= this.getSizeContribution(Gene.size_minor4, 1, 1.002f);
        size *= this.getSizeContribution(Gene.size_minor4, 2, 0.998004f);
        size *= this.getSizeContribution(Gene.size_minor4, 3, 1.008f);
        size *= this.getSizeContribution(Gene.size_minor4, 4, 0.99206346f);
        size *= this.getSizeContribution(Gene.size_minor5, 1, 1.001f);
        size *= this.getSizeContribution(Gene.size_minor5, 2, 0.99900097f);
        size *= this.getSizeContribution(Gene.size_minor5, 3, 1.005f);
        size *= this.getSizeContribution(Gene.size_minor5, 4, 0.99502486f);
        size *= this.getSizeContribution(Gene.size_minor6, 1, 1.0025f);
        size *= this.getSizeContribution(Gene.size_minor6, 2, 0.9975062f);
        size *= this.getSizeContribution(Gene.size_minor6, 3, 1.005f);
        size *= this.getSizeContribution(Gene.size_minor6, 4, 0.99502486f);
        size *= this.getSizeContribution(Gene.size_minor7, 1, 1.0025f);
        size *= this.getSizeContribution(Gene.size_minor7, 2, 0.9975062f);
        size *= this.getSizeContribution(Gene.size_minor7, 3, 1.005f);
        size *= this.getSizeContribution(Gene.size_minor7, 4, 0.99502486f);
        for (int i = 0; i < 8; ++i) {
            for (n = 1; n < 5; ++n) {
                float scale = 1.0f + 0.001f * (float)n;
                int large = 2 * n - 1;
                int small = 2 * n;
                Gene gene = Gene.valueOf("size_subtle" + i);
                size *= this.getSizeContribution(gene, large, scale);
                size *= this.getSizeContribution(gene, small, 1.0f / scale);
            }
        }
        if (this.getAllele(Gene.size0, 0) == 1) {
            size *= 1.06f;
        }
        if (this.isHomozygous(Gene.size1, 1)) {
            size *= 1.1f;
        } else if (this.hasAllele(Gene.size1, 1)) {
            size *= 1.08f;
        }
        size *= this.getSizeContribution(Gene.size2, 1, 1.002f);
        size *= this.getSizeContribution(Gene.size2, 2, 1.03f);
        size *= this.getSizeContribution(Gene.size2, 3, 1.05f);
        if (this.getAllele(Gene.size3, 1) == 1) {
            size = (float)((double)size / 1.08);
        }
        float[] size4 = new float[]{1.0f, 1.0f};
        block8: for (n = 0; n < 2; ++n) {
            switch (this.getAllele(Gene.size4, n)) {
                case 1: {
                    size4[n] = 0.99502486f;
                    continue block8;
                }
                case 2: {
                    size4[n] = 0.98039216f;
                    continue block8;
                }
                case 3: {
                    size4[n] = 0.952381f;
                    continue block8;
                }
                case 4: {
                    size4[n] = 0.9433963f;
                }
            }
        }
        float smaller = Math.min(size4[0], size4[1]);
        float larger = Math.max(size4[0], size4[1]);
        size = (float)((double)size * (Math.pow(smaller, 0.4) * Math.pow(larger, 1.6)));
        size *= this.getSizeContribution(Gene.donkey_size0, 1, 1.01f);
        size *= this.getSizeContribution(Gene.donkey_size0, 2, 1.03f);
        size *= this.getSizeContribution(Gene.donkey_size1, 1, 1.02f);
        size *= this.getSizeContribution(Gene.donkey_size1, 2, 1.04f);
        size *= this.getSizeContribution(Gene.donkey_size2, 1, 0.98039216f);
        size *= this.getSizeContribution(Gene.donkey_size2, 2, 0.9615385f);
        size *= this.getSizeContribution(Gene.donkey_size3, 1, 0.9433963f);
        if (this.isHomozygous(Gene.donkey_size4, 1)) {
            size /= 1.1f;
        } else if (this.hasAllele(Gene.donkey_size4, 1)) {
            size /= 1.02f;
        }
        size *= this.getSizeContribution(Gene.donkey_size5, 1, 1.025f);
        if (this.isHomozygous(Gene.donkey_size6, 1)) {
            size /= 1.06f;
        } else if (this.hasAllele(Gene.donkey_size6, 1)) {
            size /= 1.04f;
        }
        int r = this.getRandom("size") >>> 1;
        return size *= 1.0f + 0.01f * (float)(r % 64 - 32) / 32.0f;
    }

    public float getCurrentScale() {
        float birthSize = (float)Math.min(0.46 * (double)this.entity.getMotherSize(), 0.55 * (double)this.getAdultScale());
        if (!((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue()) {
            birthSize = 0.46f;
        }
        float f = this.entity.getFractionGrown();
        f = Math.min(1.0f, Math.max(0.0f, f));
        return this.getAdultScale() * f + birthSize * (1.0f - f);
    }

    public float getAdultScale() {
        float size = this.getGeneticScale();
        if (((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue()) {
            size = (float)(Math.pow(size, 0.7) * Math.pow(this.entity.getMotherSize(), 0.3));
        }
        return size;
    }

    public float getGeneticWeightKg() {
        float scale = this.getAdultScale();
        return 362.9f * scale * scale * scale;
    }

    public float getGeneticHeightCm() {
        float scale = this.getAdultScale();
        return 132.0f * scale;
    }

    public boolean isMiniature() {
        return (double)this.getGeneticWeightKg() < 317.5;
    }

    public boolean isLarge() {
        return this.getGeneticWeightKg() > 635.0f;
    }

    public int getAge() {
        if (this.entity instanceof AbstractHorseGenetic) {
            return ((AbstractHorseGenetic)this.entity).getDisplayAge();
        }
        return 0;
    }

    protected int chooseRandomAllele(List<Float> distribution) {
        float n = this.entity.getRand().nextFloat();
        for (int i = 0; i < distribution.size(); ++i) {
            if (!(n < distribution.get(i).floatValue())) continue;
            return i;
        }
        return distribution.size() - 1;
    }

    protected void randomizeGenes(Breed breed) {
        for (Enum gene : this.listGenes()) {
            if (!breed.contains(gene)) {
                HorseColors.logger.debug(gene.toString() + " is not in the given map");
            }
            List<Float> distribution = breed.get(gene);
            int allele0 = this.chooseRandomAllele(distribution);
            int allele1 = this.chooseRandomAllele(distribution);
            this.setAllele(gene, 0, allele0);
            this.setAllele(gene, 1, allele1);
        }
    }

    public void randomize(Breed breed) {
        this.randomizeGenes(breed);
        if (this.isHomozygous(Gene.frame, 1)) {
            this.setAllele(Gene.frame, 0, 0);
        }
        if (this.isHomozygous(Gene.KIT, 15)) {
            this.setAllele(Gene.KIT, 0, 0);
        }
        this.entity.setSeed(this.entity.getRand().nextInt());
        this.entity.setMale(rand.nextBoolean());
    }

    public String judgeStatRaw(int val) {
        if (val <= 0) {
            return "worst";
        }
        if (val <= 2) {
            return "bad";
        }
        if (val <= 5) {
            return "avg";
        }
        if (val <= 7) {
            return "good";
        }
        return "best";
    }

    private String judgeStatRaw12(int val) {
        if (val <= 1) {
            return "worst";
        }
        if (val <= 4) {
            return "bad";
        }
        if (val <= 7) {
            return "avg";
        }
        if (val <= 10) {
            return "good";
        }
        return "best";
    }

    public String judgeStat(int val, String loc) {
        return Util.translate(loc + this.judgeStatRaw(val));
    }

    public String judgeStat(String name, int min, int max) {
        return Util.translate("stats." + this.judgeStatRaw(this.sumGenes(Gene.class, name, min, max)));
    }

    private String judgeStat12(String name, int min, int max) {
        return Util.translate("stats." + this.judgeStatRaw12(this.sumGenes(Gene.class, name, min, max)));
    }

    private void listGenes(ArrayList<String> list, List<Gene> genelist) {
        for (Gene gene : genelist) {
            if (gene == Gene.KIT && this.species != Species.DONKEY) {
                String tobianoLocation = "genes.tobiano";
                String tobi = Util.translate(tobianoLocation + ".name") + ": ";
                String a1 = HorseAlleles.isTobianoAllele(this.getAllele(Gene.KIT, 0)) ? "Tobiano" : "Wildtype";
                String a2 = HorseAlleles.isTobianoAllele(this.getAllele(Gene.KIT, 1)) ? "Tobiano" : "Wildtype";
                tobi = tobi + Util.translate(tobianoLocation + ".allele" + a1) + "/";
                tobi = tobi + Util.translate(tobianoLocation + ".allele" + a2);
                list.add(tobi);
            }
            String translationLocation = "genes." + gene.toString();
            String s = Util.translate(translationLocation + ".name") + ": ";
            s = s + Util.translate(translationLocation + ".allele" + this.getAllele(gene, 0)) + "/";
            s = s + Util.translate(translationLocation + ".allele" + this.getAllele(gene, 1));
            list.add(s);
        }
    }

    @Override
    public List<List<String>> getBookContents() {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        ArrayList<String> physical = new ArrayList<String>();
        physical.add(Util.translate("book.physical"));
        String health = Util.translate("stats.health");
        health = health + "\n";
        health = health + "  " + Util.translate("stats.health1") + ": " + this.judgeStat("health", 0, 4) + "\n";
        health = health + "  " + Util.translate("stats.health2") + ": " + this.judgeStat("health", 4, 8) + "\n";
        health = health + "  " + Util.translate("stats.health3") + ": " + this.judgeStat("health", 8, 12) + "\n  ";
        health = health + Util.translate("stats.immune") + ": " + this.judgeStat((int)this.getImmuneHealth(), "stats.immune.");
        if (((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue()) {
            health = health + "\n" + Util.translate("stats.health_size_note");
        }
        String healthEffects = "";
        if (this.isLethalWhite()) {
            healthEffects = healthEffects + "\n" + Util.translate("stats.health.lethal_white");
        }
        if (((Boolean)HorseConfig.Genetics.enableHealthEffects.get()).booleanValue()) {
            float h2;
            if (this.getDeafHealthLoss() > 0.5f) {
                healthEffects = healthEffects + "\n" + Util.translate("stats.health.deaf");
            }
            float h = this.getHealth() + this.getSilverHealthLoss();
            if ((int)this.getHealth() != (int)h) {
                healthEffects = healthEffects + "\n" + Util.translate("stats.health.MCOA");
            }
            if ((int)h != (int)(h2 = h + this.getGrayHealthLoss())) {
                healthEffects = healthEffects + "\n" + Util.translate("stats.health.melanoma");
            }
            if ((int)h2 != (int)(h2 + this.getERUHealthLoss())) {
                healthEffects = healthEffects + "\n" + Util.translate("stats.health.ERU");
            }
            if (this.isHomozygous(Gene.leopard, 1)) {
                healthEffects = healthEffects + "\n" + Util.translate("stats.health.CSNB");
            }
        }
        physical.add(health);
        String athletics = "";
        if (this.species == Species.DONKEY) {
            athletics = athletics + "\n" + Util.translate("stats.athletics1") + ": " + this.judgeStat("athletics", 0, 8);
        } else {
            athletics = athletics + Util.translate("stats.athletics") + "\n";
            athletics = athletics + "  " + Util.translate("stats.athletics1") + ": " + this.judgeStat("athletics", 0, 4) + "\n";
            athletics = athletics + "  " + Util.translate("stats.athletics2") + ": " + this.judgeStat("athletics", 4, 8);
        }
        physical.add(athletics);
        String speed = Util.translate("stats.speed");
        if (this.species == Species.DONKEY) {
            speed = speed + ": " + this.judgeStat12("speed", 0, 12);
        } else {
            speed = speed + "\n";
            speed = speed + "  " + Util.translate("stats.speed1") + ": " + this.judgeStat("speed", 0, 4) + "\n";
            speed = speed + "  " + Util.translate("stats.speed2") + ": " + this.judgeStat("speed", 4, 8) + "\n";
            speed = speed + "  " + Util.translate("stats.speed3") + ": " + this.judgeStat("speed", 8, 12);
        }
        physical.add(speed);
        String jump = Util.translate("stats.jump");
        if (this.species == Species.DONKEY) {
            jump = jump + ": " + this.judgeStat12("jump", 0, 12);
        } else {
            jump = jump + "\n";
            jump = jump + "  " + Util.translate("stats.jump1") + ": " + this.judgeStat("jump", 0, 4) + "\n";
            jump = jump + "  " + Util.translate("stats.jump2") + ": " + this.judgeStat("jump", 4, 8) + "\n";
            jump = jump + "  " + Util.translate("stats.jump3") + ": " + this.judgeStat("jump", 8, 12);
        }
        physical.add(jump);
        physical.add(healthEffects);
        if (((Boolean)HorseConfig.Genetics.useGeneticStats.get()).booleanValue()) {
            if (((Boolean)HorseConfig.Genetics.bookShowsTraits.get()).booleanValue()) {
                contents.add(physical);
            }
        }
        ImmutableList colorgenelist = ImmutableList.of((Object)((Object)Gene.extension), (Object)((Object)Gene.agouti), (Object)((Object)Gene.dun), (Object)((Object)Gene.gray), (Object)((Object)Gene.cream), (Object)((Object)Gene.silver), (Object)((Object)Gene.champagne), (Object)((Object)Gene.KIT), (Object)((Object)Gene.frame), (Object)((Object)Gene.MITF), (Object)((Object)Gene.leopard), (Object)((Object)Gene.PATN1), (Object[])new Gene[]{Gene.mushroom, Gene.tiger_eye});
        if (this.species == Species.DONKEY) {
            colorgenelist = ImmutableList.of((Object)((Object)Gene.extension), (Object)((Object)Gene.agouti), (Object)((Object)Gene.KIT));
        }
        ArrayList<String> test_results = new ArrayList<String>();
        if (((Boolean)HorseConfig.Genetics.bookShowsGenes.get()).booleanValue()) {
            test_results.add(Util.translate("book.genetic_color"));
            this.listGenes(test_results, (List<Gene>)colorgenelist);
            if (((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue() && this.species != Species.DONKEY) {
                test_results.add("");
                test_results.add(Util.translate("book.genetic_size"));
                this.listGenes(test_results, (List<Gene>)ImmutableList.of((Object)((Object)Gene.LCORL), (Object)((Object)Gene.HMGA2)));
                test_results.add("");
                test_results.add(Util.translate("book.size_disclaimer"));
            }
        }
        if (!test_results.isEmpty()) {
            contents.add(test_results);
        }
        return contents;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setTexturePaths() {
        this.textureLayers = HorseColorCalculator.getTexturePaths(this);
        this.textureCacheName = "horse/cache_" + this.textureLayers.getUniqueName();
    }

    @Override
    public String genesToString() {
        String answer = this.entity.isMale() ? "M" : "F";
        String genes = this.entity.getGeneData();
        for (int i = 0; i < genes.length(); ++i) {
            answer = answer + String.format("%1$02X", genes.charAt(i));
        }
        return answer;
    }

    @Override
    public void genesFromString(String s) {
        if (s.length() % 8 != 0) {
            String g = s.substring(0, 1);
            this.entity.setMale(g.equals("M"));
            s = s.substring(1);
        }
        if (s.length() <= 96) {
            Map<String, Integer> map = this.parseLegacyGenes(s);
            this.setLegacyGenes(map);
        } else {
            String genes = "";
            for (int i = 0; i < s.length() / 4; ++i) {
                for (int n = 0; n < 2; ++n) {
                    String c = s.substring(4 * i + 2 * n, 4 * i + 2 * n + 2);
                    genes = genes + (char)Short.parseShort(c, 16);
                }
            }
            this.entity.setGeneData(genes);
        }
    }

    private Map<String, Integer> parseLegacyGenes(String s) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < chromosomes.size(); ++i) {
            int val = 0;
            try {
                String c = s.substring(8 * i, 8 * (i + 1));
                val = (int)Long.parseLong(c, 16);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            map.put((String)chromosomes.get(i), val);
        }
        if (s.length() <= 88) {
            this.datafixAddingFourthChromosome(map);
        }
        return map;
    }

    private void setGenericGenes(String name, int len, int val) {
        for (int i = 0; i < len; ++i) {
            Gene gene = Gene.valueOf(name + i);
            this.setAllele(gene, 0, val & 1);
            this.setAllele(gene, 1, (val >>>= 1) & 1);
            val >>>= 1;
        }
    }

    public void setLegacyGenes(Map<String, Integer> map) {
        for (Enum gene : this.listGenes()) {
            if (gene == Gene.speed0) break;
            if (!map.containsKey(this.getGeneChromosome(gene.toString()))) continue;
            int allele0 = this.getAlleleOld(gene.toString(), 0, map);
            int allele1 = this.getAlleleOld(gene.toString(), 1, map);
            if (gene == Gene.extension) {
                allele0 = allele0 >= 4 ? 1 : 0;
                allele1 = allele1 >= 4 ? 1 : 0;
            } else if (gene == Gene.agouti) {
                allele0 = Math.min(4, allele0);
                allele1 = Math.min(4, allele1);
            }
            this.setAllele(gene, 0, allele0);
            this.setAllele(gene, 1, allele1);
        }
        int speed = 0;
        if (map.containsKey("speed")) {
            speed = map.get("speed");
            this.setGenericGenes("speed", 12, speed);
        }
        int jump_residue = 0;
        if (map.containsKey("jump")) {
            jump_residue = map.get("jump") & 0xFF;
            int jump = map.get("jump") >>> 8;
            this.setGenericGenes("jump", 12, jump);
        }
        if (map.containsKey("speed") || map.containsKey("jump")) {
            int athletics = speed >>> 24 | jump_residue << 8;
            this.setGenericGenes("athletics", 8, athletics);
        }
        if (map.containsKey("health")) {
            int health = map.get("health");
            this.setGenericGenes("health", 12, health);
        }
        if (map.containsKey("mhc1") || map.containsKey("mhc2") || map.containsKey("immune")) {
            long mhc1 = 0L;
            long mhc2 = 0L;
            if (map.containsKey("mhc1")) {
                mhc1 = map.get("mhc1").intValue();
            }
            if (map.containsKey("mhc2")) {
                mhc2 = map.get("mhc2").intValue();
            }
            long mhc = mhc1 | mhc2 << 32;
            int immune = 0;
            if (map.containsKey("immune")) {
                immune = map.get("immune");
            }
            for (int i = 0; i < 8; ++i) {
                for (int n = 0; n < 2; ++n) {
                    this.setAllele(Gene.valueOf("immune" + i), n, immune & 3);
                    immune >>>= 2;
                    this.setAllele(Gene.valueOf("mhc" + i), n, (int)(mhc & 0xFL));
                    mhc >>>= 4;
                }
            }
        }
        Random randgenes = new Random(this.getRandom("leg_white"));
        for (int n = 0; n < 2; ++n) {
            for (int i = 0; i < 8; ++i) {
                this.setAllele(Gene.valueOf("size_minor" + i), n, (randgenes.nextInt() >>> 1) % 5);
            }
        }
    }

    public Map<String, Integer> getLegacyGenes() {
        Enum gene;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String chr : chromosomes) {
            map.put(chr, 0);
        }
        List<Enum> genes = this.listGenes();
        int i = 0;
        for (i = 0; i < genes.size() && !"speed0".equals((gene = genes.get(i)).toString()); ++i) {
            this.setAlleleOld(gene.toString(), 0, this.getAllele(gene, 0), map);
            this.setAlleleOld(gene.toString(), 1, this.getAllele(gene, 1), map);
        }
        ImmutableList stats = ImmutableList.of((Object)"speed", (Object)"jump", (Object)"health");
        for (Object stat : stats) {
            int chr = 0;
            for (int s = 0; s < 16; ++s) {
                Enum statGene = genes.get(i + s);
                int allele0 = this.getAllele(statGene, 0) & 1;
                int allele1 = this.getAllele(statGene, 1) & 1;
                chr = chr | allele0 << 2 * s | allele1 << 2 * s + 1;
            }
            i += 16;
            map.put((String)stat, chr);
        }
        ImmutableList immunes = ImmutableList.of((Object)"mhc1", (Object)"mhc2", (Object)"immune");
        for (String immune : immunes) {
            map.put(immune, this.entity.getRand().nextInt());
        }
        for (int n = 0; n < 2; ++n) {
            if (this.getAlleleOld("extension", n, map) == 0) continue;
            this.setAlleleOld("extension", n, 4, map);
        }
        return map;
    }

    @Override
    public boolean isValidGeneString(String s) {
        if (s.length() < 2) {
            return false;
        }
        if (s.length() % 8 == 0) {
            return s.matches("[0-9a-fA-F]*");
        }
        String g = s.substring(0, 1);
        if (!g.equals("M") && !g.equals("F")) {
            return false;
        }
        if ((s = s.substring(1)).length() % 4 != 0) {
            return false;
        }
        return s.matches("[0-9a-fA-F]*");
    }

    public void datafixAddingFourthChromosome(Map<String, Integer> map) {
        if (!(map.containsKey(this.getGeneChromosome("MITF")) || map.containsKey(this.getGeneChromosome("KIT")) || map.containsKey(this.getGeneChromosome("cream")))) {
            return;
        }
        int prevSplash = this.getNamedGene("MITF", map);
        this.setAlleleOld("MITF", 0, prevSplash & 3, map);
        this.setAlleleOld("MITF", 1, prevSplash >>> 2 & 3, map);
        this.setAlleleOld("PAX3", 0, prevSplash >>> 4 & 3, map);
        this.setAlleleOld("PAX3", 1, prevSplash >>> 6 & 3, map);
        int prevKIT = this.getNamedGene("KIT", map);
        this.setAlleleOld("white_suppression", 0, prevKIT & 1, map);
        this.setAlleleOld("white_suppression", 1, prevKIT >>> 1 & 1, map);
        this.setAlleleOld("KIT", 0, prevKIT >>> 2 & 0xF, map);
        this.setAlleleOld("KIT", 1, prevKIT >>> 6 & 0xF, map);
        this.setAlleleOld("frame", 0, prevKIT >>> 10 & 1, map);
        this.setAlleleOld("frame", 1, prevKIT >>> 11 & 1, map);
        int prevCream = this.getNamedGene("cream", map);
        this.setAlleleOld("cream", 0, prevCream & 3, map);
        this.setAlleleOld("cream", 1, prevCream >>> 2 & 3, map);
        this.setAlleleOld("silver", 0, prevCream >>> 4 & 1, map);
        this.setAlleleOld("silver", 1, prevCream >>> 5 & 1, map);
    }

    public static enum Gene {
        extension,
        agouti,
        dun,
        gray,
        cream,
        liver,
        flaxen1,
        flaxen2,
        dapple,
        sooty1,
        sooty2,
        sooty3,
        light_belly,
        mealy1,
        mealy2,
        KIT,
        MITF,
        leopard,
        PATN1,
        PATN2,
        PATN3,
        gray_suppression,
        slow_gray1,
        slow_gray2,
        slow_gray3,
        white_star,
        white_forelegs,
        white_hindlegs,
        gray_melanoma,
        gray_mane1,
        gray_mane2,
        rufous,
        dense,
        champagne,
        cameo,
        ivory,
        donkey_dark,
        cross,
        reduced_points,
        light_legs,
        less_light_legs,
        donkey_dun,
        flaxen_boost,
        light_dun,
        marble,
        leopard_suppression,
        leopard_suppression2,
        PATN_boost1,
        PATN_boost2,
        PAX3,
        white_suppression,
        frame,
        silver,
        dark_red,
        liver_boost,
        LCORL,
        HMGA2,
        mushroom,
        speed0,
        speed1,
        speed2,
        speed3,
        speed4,
        speed5,
        speed6,
        speed7,
        speed8,
        speed9,
        speed10,
        speed11,
        athletics0,
        athletics1,
        athletics2,
        athletics3,
        athletics4,
        athletics5,
        athletics6,
        athletics7,
        jump0,
        jump1,
        jump2,
        jump3,
        jump4,
        jump5,
        jump6,
        jump7,
        jump8,
        jump9,
        jump10,
        jump11,
        health0,
        health1,
        health2,
        health3,
        health4,
        health5,
        health6,
        health7,
        health8,
        health9,
        health10,
        health11,
        immune0,
        immune1,
        immune2,
        immune3,
        immune4,
        immune5,
        immune6,
        immune7,
        mhc0,
        mhc1,
        mhc2,
        mhc3,
        mhc4,
        mhc5,
        mhc6,
        mhc7,
        size_minor0,
        size_minor1,
        size_minor2,
        size_minor3,
        size_minor4,
        size_minor5,
        size_minor6,
        size_minor7,
        size0,
        size1,
        size2,
        size3,
        size4,
        size_subtle0,
        size_subtle1,
        size_subtle2,
        size_subtle3,
        size_subtle4,
        size_subtle5,
        size_subtle6,
        size_subtle7,
        double_ovulation,
        donkey_size0,
        donkey_size1,
        donkey_size2,
        donkey_size3,
        donkey_size4,
        donkey_size5,
        donkey_size6,
        color,
        rabicano,
        blue_eye_shade1,
        blue_eye_shade2,
        blue_eye_shade3,
        tiger_eye,
        brown_eye_shade1,
        brown_eye_shade2,
        brown_eye_shade3;

    }
}

